### 功能

``` shell
void setup(DpdkEthercat *dpdk);	
void print_port_info(DpdkEthercat *dpdk);							
void set_lcore(DpdkEthercat *dpdk, unsigned lcore_id);				
void set_delay_µs(DpdkEthercat *dpdk, unsigned int delay_µs);
void sync_callback(struct rte_timer *tim, void *arg);				
void sync_with_master(DpdkEthercat *dpdk);							
void print_stats(DpdkEthercat *dpdk);								
void check_link_statµs(DpdkEthercat *dpdk);							
void run(DpdkEthercat *dpdk);	
int enqueue_tx_packet(DpdkEthercat *dpdk, struct rte_mbuf *mbuf);	
int enqueue_rx_packet(DpdkEthercat *dpdk, struct rte_mbuf *mbuf);										
int port_init(DpdkEthercat *dpdk, uint16_t port);					
unsigned int get_delay_µs(const DpdkEthercat *dpdk);					
struct rte_mbuf *dequeue_tx_packet(DpdkEthercat *dpdk);				
struct rte_mbuf *dequeue_rx_packet(DpdkEthercat *dpdk);				
struct rte_mempool *get_mbuf_pool(const DpdkEthercat *dpdk);														
``` 

---
### 详细说明
提供了用户态实现DPDK-Ethercat网口驱动(PMD模式)

#### 功能文档

-  **setup**

    void setup(DpdkEthercat *dpdk)										

    初始化DPDK-Driver

    参数:

    **dpdk**  DPDK-Ethercat网口对象;
_________________

- **port_init**
    int port_init(DpdkEthercat *dpdk, uint16_t port)					
    
    初始化DPDK网口

    参数:

    **dpdk**  DPDK-Ethercat网口对象;

    **port**  绑定了VFIO网口的列表序号, 比如:0;

    返回值:

    **0**: 成功;

    **-1**: 失败;
_________________

- **print_port_info**

    void print_port_info(DpdkEthercat *dpdk)	

    端口消息打印

    参数:

    **dpdk**  DPDK-Ethercat网口对象;
_________________

- **set_lcore**

    void set_lcore(DpdkEthercat *dpdk, unsigned lcore_id)				

    指定DPDK-Driver运行核心

    参数:

    **dpdk**  DPDK-Ethercat网口对象;

    **lcore_id**  绑定了CPU核心号, 比如:0;
_________________

- **set_delay_µs**

    void set_delay_µs(DpdkEthercat *dpdk, unsigned int delay_µs)		

    设置PMD模式下轮询延时值		

    参数:

    **dpdk**  DPDK-Ethercat网口对象;

    **delay_µs**  延时时间, 单位: µs;
_________________

- **get_delay_µs**

    unsigned int get_delay_µs(const DpdkEthercat *dpdk)				

    获取PMD模式下轮询延时值	

    参数:

    **dpdk**  DPDK-Ethercat网口对象;
_________________

- **enqueue_tx_packet**

    int enqueue_tx_packet(DpdkEthercat *dpdk, struct rte_mbuf *mbuf)	

    发送数据包入列

    参数:

    **dpdk**  DPDK-Ethercat网口对象;

    **mbuf**  需要发送的数据包;

    返回值:

    **0**: 成功;

    **-1**: 失败;
_________________

- **enqueue_rx_packet**

    int enqueue_rx_packet(DpdkEthercat *dpdk, struct rte_mbuf *mbuf)	

    接收数据包入列

    参数:

    **dpdk**  DPDK-Ethercat网口对象;

    **mbuf**  需要接收的数据包;

    返回值:

    **0**: 成功;

    **-1**: 失败;
_________________

- **dequeue_tx_packet**

    struct rte_mbuf *dequeue_tx_packet(DpdkEthercat *dpdk)				

    发送数据包出列

    参数:

    **dpdk**  DPDK-Ethercat网口对象;

    返回值:

    **rte_mbuf**: 解析的发送数据包被内容;
_________________

- **dequeue_rx_packet**

    struct rte_mbuf *dequeue_rx_packet(DpdkEthercat *dpdk)				

    接收数据包出列

    参数:

    **dpdk**  DPDK-Ethercat网口对象;

    返回值:

    **rte_mbuf**: 解析的接收数据包被内容;
_________________

- **get_mbuf_pool**

    struct rte_mempool *get_mbuf_pool(const DpdkEthercat *dpdk)		

    获取DPDK内存池	

    参数:

    **dpdk**  DPDK-Ethercat网口对象;

    返回值:

    **rte_mempool**: DPDK内存池对象;		
_________________

- **sync_callback**

    void sync_callback(struct rte_timer *tim, void *arg)				

    同步模式回调函数

    参数:

    **tim**  DPDK轮询定时器对象;

    **arg**  回调函数;
_________________

- **sync_with_master**

    void sync_with_master(DpdkEthercat *dpdk)							

    Ethercat主站同步

    参数:

    **dpdk**  DPDK-Ethercat网口对象;
_________________

- **print_stats**

    void print_stats(DpdkEthercat *dpdk)								

    DPDK状态打印

    参数:

    **dpdk**  DPDK-Ethercat网口对象;
_________________

- **check_link_statµs**

    void check_link_statµs(DpdkEthercat *dpdk)	

    检查网口连接状态

    参数:

    **dpdk**  DPDK-Ethercat网口对象;
_________________

- **run**

    void run(DpdkEthercat *dpdk)		

    驱动执行

    参数:

    **dpdk**  DPDK-Ethercat网口对象;
_________________